--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--
rollout DYNdxfImport ""
(

  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCdxfFiles           = #()
  local LOCfilesAlreadyLoaded = #()
  local LOCmatIDarray         = #()
  local LOCallowDnSelection   = true
  local LOCpopupMenu          = undefined
  local LOCdirectory

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNmakeDxfImportPopUpMenu FUNlv =
  (
    DYNdxfImport.LOCpopupMenu = undefined
    if DYNdxfImport.dnFiles.Items.count > 0 then
    (
      rcmenu LOCpopupMenu
      (
        menuItem  MNDYNselectAll   checked:false
        menuItem  MNDYNselectNone  checked:false

        on LOCpopupMenu open do
        (
          MNDYNselectAll.text  = DYNuiResourcesMenus[14]
          MNDYNselectNone.text = DYNuiResourcesMenus[15]
        )

        on MNDYNselectAll  picked do (for i = 1 to DYNdxfImport.dnFiles.Items.count do (DYNdxfImport.dnFiles.Items.item[i-1].checked = true))
        on MNDYNselectNone picked do (for i = 1 to DYNdxfImport.dnFiles.Items.count do (DYNdxfImport.dnFiles.Items.item[i-1].checked = false))
      )
      registerRightClickMenu DYNdxfImport.LOCpopupMenu
    )
  )

  fn DYNFUNfindDXFfiles FUNdirectory =
  (
    if FUNdirectory != undefined then
    (
      local LOCdxfDetails = #()

      --- Set Up DXF File List
      local LOCtempFileArray = getFiles (FUNdirectory + "\\" + "*.dxf" )
      for i = 1 to LOCtempFileArray.count do
      (
        append LOCdxfDetails #(LOCtempFileArray[i], (filenamefrompath LOCtempFileArray[i]), "", "", "", (random (color 20 20 20) (color 175 175 175)), 26, false)
      )

      if LOCdxfDetails.count > 0 then
      (
        DYNdxfImport.title = DYNuiRolloutNames[47] + " [" + (DYNFUNtrimPathName FUNdirectory 400) + "]"
        DYNdxfImport.dnFiles.Items.Clear()

        ---Check to see which DXF files have already been loaded
        DYNdxfImport.LOCfilesAlreadyLoaded = #()
        for i = 1 to geometry.count do
        (
          if (getAppData geometry[i] 421) == "Dynamite" and (getAppData geometry[i] 422) == "8" then
          (
            append DYNdxfImport.LOCfilesAlreadyLoaded (getAppData geometry[i] 424)
          )
        )

        ---Set Up Material Drop Down List
        DYNdxfImport.DDDYNmatChanID.items = LOCmatIDarray
        DYNdxfImport.DDDYNmatChanID.selection = DYNdxfImport.DDDYNmatChanID.items.count
        DYNdxfImport.DDDYNmatChanID.enabled = true

        --- Cycle Through DXF File List
        for i = 1 to LOCdxfDetails.count do
        (
          --- Get filename from file
          local LOCfileName = LOCdxfDetails[i][2]

          --- Add File Size Indicator
          local LOCfileSize = (getfileSize LOCdxfDetails[i][1]) as string
          LOCfileSize = (substring LOCfileSize 1 (LOCfileSize.count - 3))
          if LOCfileSize.count >= 4 then
          (
            LOCfileSize = (substring LOCfileSize 1 (LOCfileSize.count - 3)) + "," + (substring LOCfileSize (LOCfileSize.count - 2) -1)
          )
          LOCfileSize = LOCfileSize + DYNuiResourcesLabels[384]
          LOCdxfDetails[i][3] = LOCfileSize

          --- Add File Creation Date Indicator
          LOCdxfDetails[i][4] = DYNFUNgetFileCreationTime LOCdxfDetails[i][1] true
          LOCdxfDetails[i][5] = DYNFUNgetFileModifyTime   LOCdxfDetails[i][1] true

          --- Add Object WireColor Parameter
          local LOCfileWireColor = LOCdxfDetails[i][6]
          if (substring LOCfileName 1 1) == "C" then LOCfileWireColor = (color 50 50 75)
          if (substring LOCfileName 1 1) == "G" then LOCfileWireColor = (color 50 125 50)
          if (substring LOCfileName 1 1) == "W" then LOCfileWireColor = (color 65 65 160)
          if (substring LOCfileName 1 1) == "H" then LOCfileWireColor = (color 75 75 100)
          if (substring LOCfileName 1 1) == "F" then LOCfileWireColor = (color 160 160 135)
          LOCdxfDetails[i][6] = LOCfileWireColor

          --- Add Object Material ID
          local LOCfileMaterialID = LOCdxfDetails[i][7]
          if (substring LOCfileName 1 1) == "C" then LOCfileMaterialID = 18
          if (substring LOCfileName 1 1) == "G" then LOCfileMaterialID = 27
          if (substring LOCfileName 1 1) == "W" then LOCfileMaterialID = 20
          if (substring LOCfileName 1 1) == "H" then LOCfileMaterialID = 22
          if (substring LOCfileName 1 1) == "F" then LOCfileMaterialID = 19
          LOCdxfDetails[i][7] = LOCfileMaterialID
          LOCdxfDetails[i][8] = false
        )

        --- Populate the ListView
        DYNdxfImport.LOCallowDnSelection = false
        local LOClistItemRange           = #()
        for i = 1 to LOCdxfDetails.count do
        (
          local LOClistItem      = dotNetObject "System.Windows.Forms.ListViewItem" (filenamefromPath LOCdxfDetails[i][1])
          local LOCsubItem1      = LOClistItem.SubItems.add (LOCdxfDetails[i][3])
          local LOCsubItem2      = LOClistItem.SubItems.add (LOCmatIDarray[LOCdxfDetails[i][7]])
          LOClistItem.tag        = LOCdxfDetails[i][1]
          LOClistItem.imageIndex = 40

          if (findItem LOCfilesAlreadyLoaded LOCdxfDetails[i][1]) > 0 then
          (
            LOClistItem.forecolor = DYNFUNdnColor LOCforeColor
          )
          append LOClistItemRange LOClistItem
        )
        DYNdxfImport.dnFiles.Items.AddRange LOClistItemRange

        ---Set up DXF File Details Panel
        DYNdxfImport.dnFiles.Items.item[0].selected = true
        DYNdxfImport.DYNFUNselectDXFlistItem 1 LOCdxfDetails
        DYNdxfImport.BUDYNselAll.enabled  = true
        DYNdxfImport.BUDYNselNone.enabled = true
        DYNdxfImport.LOCallowDnSelection  = true
      )
    )

    LOCdxfDetails -- return value
  )

  fn DYNFUNselectDXFlistItem FUNarg FUNarray =
  (
    DYNdxfImport.LBDYNfDate.text          = FUNarray[FUNarg][2]
    DYNdxfImport.LBDYNcDate.text          = DYNFUNconvertGUPdate FUNarray[FUNarg][4]
    DYNdxfImport.LBDYNmDate.text          = DYNFUNconvertGUPdate FUNarray[FUNarg][5]
    DYNdxfImport.CODYNcolor.color         = FUNarray[FUNarg][6]
    DYNdxfImport.DDDYNmatChanID.selection = FUNarray[FUNarg][7]

    if DYNdxfImport.dnFiles.Items.item[FUNarg - 1].tag != "" then
    (
      DYNdxfImport.LBDYNfTitle.enabled    = true
      DYNdxfImport.LBDYNcTitle.enabled    = true
      DYNdxfImport.LBDYNmTitle.enabled    = true
      DYNdxfImport.LBDYNfDate.enabled     = true
      DYNdxfImport.LBDYNcDate.enabled     = true
      DYNdxfImport.LBDYNmDate.enabled     = true
      DYNdxfImport.CODYNcolor.enabled     = true
      DYNdxfImport.DDDYNmatChanID.enabled = true
    )
    else
    (
      DYNdxfImport.LBDYNfTitle.enabled    = false
      DYNdxfImport.LBDYNcTitle.enabled    = false
      DYNdxfImport.LBDYNmTitle.enabled    = false
      DYNdxfImport.LBDYNfDate.enabled     = false
      DYNdxfImport.LBDYNcDate.enabled     = false
      DYNdxfImport.LBDYNmDate.enabled     = false
      DYNdxfImport.CODYNcolor.enabled     = false
      DYNdxfImport.DDDYNmatChanID.enabled = false
    )
    gc()
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  button BUABOdir             pos:[8,9]     width:127 height:20

  groupbox GPDYNgroup01       pos:[422,29]  width:155 height:169
  label LBDYNfTitle           pos:[432,46]  width:135 enabled:false
  label LBDYNfDate            pos:[432,64]  width:135
  label LBDYNcTitle           pos:[432,87]  width:135 enabled:false
  label LBDYNcDate            pos:[432,105] width:135
  label LBDYNmTitle           pos:[432,128] width:135 enabled:false
  label LBDYNmDate            pos:[432,146] width:135
  dropdownlist DDDYNmatChanID pos:[432,169] width:115 enabled:false items:#()
  colorpicker CODYNcolor      pos:[548,169] height:20 color:(color 200 200 200) fieldwidth:15

  groupbox GPDYNgroup02       pos:[422,203] width:155 height:74
  button BUDYNselAll          pos:[432,222] width:135 height:22 enabled:false
  button BUDYNselNone         pos:[432,247] width:135 height:22 enabled:false


  button BUDYNopts            pos:[7,467]   width:92  height:22
  button BUDYNhelp            pos:[101,467] width:92  height:22
  button BUDYNokok            pos:[391,467] width:92  height:22
  button BUDYNcanc            pos:[485,467] width:92  height:22

  label LBDYNstatus           pos:[8,519] width:568 height:18

  dotNetControl  dnFiles    "System.Windows.Forms.ListView"    width:405 height:421 pos:[8,35]
  dotNetControl  dnProgress "System.Windows.Forms.ProgressBar" width:568 height:14  pos:[8,500]


  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNdxfImport open do
  (
    clearSelection()
    gc() --Implement Garbage Collection Prior to Import to Clean Up MAXScript
    DYNdxfImport.title = DYNuiRolloutNames[47]
    LOCmatIDarray      = DYNFUNgetMatChannelNames (if scenematerials[DYNmatNameSurfaces] != undefined then scenematerials[DYNmatNameSurfaces] else (DYNFUNmakeCivilViewSurfaces (DYNglobalMapsPath + DYNfolderNameSurfaceMaps + "\\"))) true true DYNINImatIDlimit
    GPDYNgroup01.text  = DYNuiResourcesGroups[5]
    GPDYNgroup02.text  = DYNuiResourcesGroups[2]
    BUDYNselAll.text   = DYNuiResourcesButtons[16]
    BUDYNselNone.text  = DYNuiResourcesButtons[17]
    LBDYNfTitle.text   = DYNuiResourcesLabels[325]
    LBDYNcTitle.text   = DYNuiResourcesLabels[32]
    LBDYNmTitle.text   = DYNuiResourcesLabels[33]
    BUDYNokok.text     = DYNuiResourcesButtons[1]
    BUDYNcanc.text     = DYNuiResourcesButtons[3]
    BUDYNopts.text     = DYNuiResourcesButtons[4]
    BUDYNhelp.text     = DYNuiResourcesButtons[5]
    BUABOdir.caption   = DYNuiResourcesButtons[33]
    LBDYNstatus.text   = DYNuiResourcesStatusMessages[7]

    --- Set Up dotNetControl
    DYNFUNdnListViewStyle dnFiles true true
    dnFiles.multiSelect        = false
    dnFiles.AllowColumnReorder = false
    dnFiles.sorting            = DYNdnSortOrderClass.ascending
    local LOCcol1 = dnFiles.Columns.add DYNuiResourcesLvColumns[13] 154
    local LOCcol2 = dnFiles.Columns.add DYNuiResourcesLvColumns[14]  70 ; LOCcol2.textAlign = DYNdnHorAlignClass.right
    local LOCcol3 = dnFiles.Columns.add DYNuiResourcesLvColumns[15] 162 ; LOCcol3.textAlign = DYNdnHorAlignClass.left
    dnFiles.smallImageList = DYNdnSmImageList
  )

  on DYNdxfImport close do
  (
    LOCdxfFiles = #()
    LOCfilesAlreadyLoaded = #()
    LOCmatIDarray = #()
    dnFiles.Items.clear()
    DYNFUNonDialogClose()
  )

  on DYNdxfImport moved argPt2 do
  (
    DYNdxfLUP = argPt2
  )

  on BUABOdir pressed do
  (
    local LOCtmpDirectory = getsavepath caption:DYNuiResourcesLabels[34] initialDir:(getDir #import)

    if LOCtmpDirectory != undefined then
    (
      LOCdirectory = LOCtmpDirectory
      local TempArray = DYNFUNfindDXFfiles LOCdirectory
      if TempArray.count > 0 then
      (
        LOCdxfFiles = TempArray
        LBDYNstatus.text = DYNuiResourcesStatusMessages[6]
      )
      else
      (
        messagebox (DYNuiResourcesErrorsWarnings[62]) title:DYNuiResourcesTitlebars[1]
      )
    )
  )

  on BUDYNselAll pressed do
  (
    for i = 1 to dnFiles.items.count do
    (
      if dnFiles.items.item[i-1].tag != "" then dnFiles.items.item[i-1].checked = true
      LOCdxfFiles[i][8] = dnFiles.items.item[i-1].checked
    )
  )

  on BUDYNselNone pressed do
  (
    for i = 1 to dnFiles.items.count do
    (
      dnFiles.items.item[i-1].checked = false
      LOCdxfFiles[i][8] = dnFiles.items.item[i-1].checked
    )
  )

  on dnFiles ItemSelectionChanged arg do
  (
    if arg.isSelected and LOCallowDnSelection then
    (
      if arg.isSelected then DYNFUNselectDXFlistItem (arg.item.index + 1) LOCdxfFiles
    )
  )

  on dnFiles ItemChecked arg do
  (
    /*  "ItemChecked Event"
      .Item : <System.Windows.Forms.ListViewItem>, read-only
      .Empty : <System.EventArgs>, read-only, static
    */
    if LOCallowDnSelection then
    (
      if arg.item.tag == "" then
      (
        arg.item.checked = false
      )
      LOCdxfFiles[arg.item.index + 1][8] = arg.item.checked
    )
  )

  on dnFiles ColumnClick arg do
  (
    /* arg.column (to get to index of selected column) */
    if dnFiles.sorting == DYNdnSortOrderClass.none       then
    (
      dnFiles.sorting = DYNdnSortOrderClass.ascending
    )
    else
    (
      if dnFiles.sorting == DYNdnSortOrderClass.ascending  then
      (
        dnFiles.sorting = DYNdnSortOrderClass.descending
      )
      else
      (
        if dnFiles.sorting == DYNdnSortOrderClass.descending then dnFiles.sorting = DYNdnSortOrderClass.ascending
      )
    )
    if dnFiles.selectedItems.count > 0 then dnFiles.selectedItems.item[0].ensureVisible()
  )

  on DDDYNmatChanID selected arg do
  (
    LOCdxfFiles[(dnFiles.selectedItems.item[0].index + 1)][7] = arg
    dnFiles.selectedItems.item[0].subItems.item[2].text = LOCmatIDarray[arg]
  )

  on CODYNcolor changed arg do LOCdxfFiles[(dnFiles.selectedItems.item[0].index + 1)][6] = arg

  on BUDYNokok pressed do
  (
    local LOCshiftProceed = true
    if rootNode.DYNrootNodeStore.shiftX == 0 and rootNode.DYNrootNodeStore.shiftY == 0 and objects.count == 0 then
    (
      local LOCmessage = DYNuiResourcesQueries[36]
      LOCmessage +=      "\n\n"
      LOCmessage +=      DYNuiResourcesQueries[35]

      LOCshiftProceed = querybox LOCmessage title:DYNuiResourcesTitlebars[3] beep:false
    )
    if LOCshiftProceed then
    (
      DYNFUNremoveCSProllouts()        -- This must be carried first to prevent PositionControl rollout from having references to old objects.

      undo off
      (
        DYNFUNreadImportColorAndMatIdConfigFile()
        local LOCselectedFileCount = 0
        actionMan.executeAction 0 "300"
        DYNFUNloadVSPnodeCallBacks false
        (
          for i = 1 to LOCdxfFiles.count do
          (
            clearSelection()
            if LOCdxfFiles[i][8] == true then
            (
              dnProgress.value = ((i as float) / (LOCdxfFiles.count as float) * 100.0)
              LBDYNstatus.text = DYNuiResourcesStatusMessages[5] + " " + LOCdxfFiles[i][2]
              LOCselectedFileCount += 1

              local LOCcreatedObjects = #()
              local LOColdObjHandleArray = #(); for ii in objects do append LOColdObjHandleArray ii.inode.handle
              importFile LOCdxfFiles[i][1] #noPrompt
              local LOCnewObjHandleArray = #(); for ii in objects do append LOCnewObjHandleArray ii.inode.handle
              for ii in LOCnewObjHandleArray do
              (
                if (findItem LOColdObjHandleArray ii) == 0 then append LOCcreatedObjects (maxOps.getNodeByHandle ii)
              )

              for ii = 1 to LOCcreatedObjects.count do
              (
                local LOCmodelLayerName = if (subString LOCcreatedObjects[ii].name 1 6) == DYNimportedAcadPrefix then (subString LOCcreatedObjects[ii].name 7 -1) else ""

                --- For Imported Surfaces ------------------------------------------------------------------------------------------------------------
                if classof LOCcreatedObjects[ii] == Editable_mesh then
                (
                  local LOCobjectSwitch = 8
                  LOCcreatedObjects[ii].wireColor = LOCdxfFiles[i][6]
                  LOCcreatedObjects[ii].material = if scenematerials[DYNmatNameSurfaces] != undefined then scenematerials[DYNmatNameSurfaces] else (DYNFUNmakeCivilViewSurfaces (DYNglobalMapsPath + DYNfolderNameSurfaceMaps + "\\"))
                  for iii = 1 to LOCcreatedObjects[ii].numfaces do setfacematid LOCcreatedObjects[ii] iii LOCdxfFiles[i][7]

                  --- Add Standard Modifiers then Collapse Modifier Tree to return to Editable Mesh (i.e. if face normals are facing down flip the mesh)
                  if (getfacenormal LOCcreatedObjects[ii] 1).z < 0 then addmodifier LOCcreatedObjects[ii] (normalModifier flip:true)
                  addmodifier LOCcreatedObjects[ii] (smoothModifier autoSmooth:false)
                  addmodifier LOCcreatedObjects[ii] (UVWmap length:10 width:10 realWorldMapSize:false)
                  collapseStack LOCcreatedObjects[ii]

                  --- Apply/Remove Smoothing from Mesh
                  if DYNINIfaceSmoothing > 0.0 then
                  (
                    meshop.autoSmooth LOCcreatedObjects[ii] #{1..LOCcreatedObjects[ii].numfaces} DYNINIfaceSmoothing
                    update LOCcreatedObjects[ii]
                  )

                  --- Make all edges visible (required for later versions of MAX)
                  for iFace = 1 to LOCcreatedObjects[ii].numfaces do
                  (
                    for iEdge = 1 to 3 do setEdgeVis LOCcreatedObjects[ii] iFace iEdge true
                  )
                  update LOCcreatedObjects[ii]

                  --- Apply AppData
                  DYNFUNgenObjAppData LOCcreatedObjects[ii] LOCobjectSwitch LOCdxfFiles[i][7] LOCdxfFiles[i][1] (DYNFUNgetLocalTime()) "" "" LOCmodelLayerName

                  --- Finish Off
                  LOCcreatedObjects[ii].name = uniqueName (DYNuiResourcesNodeNames[4] + (getFilenameFile LOCdxfFiles[i][2]))
                  append DYNobjHandles[LOCobjectSwitch] LOCcreatedObjects[ii].inode.handle
                )


                --- For Imported Shapes ----------------------------------------------------------------------------------------------------------------
                if classof LOCcreatedObjects[ii] == SplineShape then
                (
                  local LOCobjectSwitch = 7
                  LOCcreatedObjects[ii].wirecolor = red
                  DYNFUNgenObjAppData LOCcreatedObjects[ii] LOCobjectSwitch 0 LOCdxfFiles[i][1] (DYNFUNgetLocalTime()) "" "" LOCmodelLayerName

                  LOCcreatedObjects[ii].name =  uniqueName (DYNuiResourcesNodeNames[5] + LOCdxfFiles[i][2])
                  append DYNobjHandles[LOCobjectSwitch] LOCcreatedObjects[ii].inode.handle
                )


                LOCcreatedObjects[ii].pos.x = (LOCcreatedObjects[ii].pos.x + rootNode.DYNrootNodeStore.shiftX)
                LOCcreatedObjects[ii].pos.y = (LOCcreatedObjects[ii].pos.y + rootNode.DYNrootNodeStore.shiftY)
              )
            )
          )
          dnProgress.value = 0
          destroyDialog DYNdxfImport
          max tool zoomextents all
        )
        DYNFUNloadVSPnodeCallBacks true
        DYNFUNnodeCreatedCallback()
        DYNproperties.DYNFUNscreenSelectionToList()
        if LOCselectedFileCount > 0 then max tool zoomextents all
      )
    )
  )

  on dnFiles MouseUp arg do
  (
    if arg.button == DYNdnmouseClass.right then
    (
      DYNFUNmakeDxfImportPopUpMenu dnFiles
      if LOCpopupMenu != undefined then popupMenu LOCpopupMenu
    )
  )


  on BUDYNopts pressed do
  (
    DYNFUNopenPreferencesPanel 6
  )

  on BUDYNcanc pressed do destroyDialog DYNdxfImport

  on BUDYNhelp pressed do DYNFUNopenHelp 13217 -- id_cv_import_dxf

)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBNBdrQ5z5rADPlsEl6shl67twhfa2hmjDz
-- V39AVIVX4zoeLvmoI1Bbjgc9jxCRK0pwogMPXtn41cjWSzUSiSqqY+Qe5HjFwhbr
-- bWSe4fY1Op/jc1eW8HhQbNPd0EOkEdVRgPsPjsaYDO5HXVy5n9PDbuRTD6b7pfBA
-- frg/r/tcyA3jr33Tna3G4bnD+YQqe1fIisZbrzfG6CSSGBbmNGTTOXfc9YTHbp/i
-- dQV5LAszzsrUSlLNhDsTu2/FtLPsQjj+p/rWrvNmWxLPkWItbC/wZnO0uhcOhmyy
-- 6GFMerUeAA1tTAZn70vLSNw0jdu8ltv0oBNERXZ/JQGKnaJtO5zB
-- -----END-SIGNATURE-----